﻿using System;
using System.Collections.Generic;
using System.Collections;
using System.Text;

namespace Aufzählungen
{
    class Queue : System.Collections.IEnumerable
    {
        elem first;
        elem last;
        
        public void Enqueue(object o)
        {
            last = new elem(o, last);
            if (first == null)
                first = last;
        }
        
        public bool IsEmpty()
        {
            return first == null;
        }
        
        public object Dequeue()
        {
            if (first == null)
                throw new InvalidOperationException();
            object o = first.value;
            first = first.next;
            if (first == null)
                last = null;
            return o;
        }

        public IEnumerator GetEnumerator()
        {
            elem e = first;
            while (e != null)
            {
                yield return e.value;
                e = e.next;
            }
        }

        class elem
        {
            public object value;
            public elem next;
            public elem(object val, elem prev)
            {
                value = val;
                if (prev != null) prev.next = this;
            }
        }
    }

    class Queue<T> : System.Collections.IEnumerable
    {
        elem<T> first;
        elem<T> last;

        public void Enqueue(T o)
        {
            last = new elem<T>(o, last);
            if (first == null)
                first = last;
        }
        
        public bool IsEmpty()
        {
            return first == null;
        }
        
        public T Dequeue()
        {
            if (first == null)
                throw new InvalidOperationException();
            T o = first.value;
            first = first.next;
            if (first == null)
                last = null;
            return o;
        }

        IEnumerator System.Collections.IEnumerable.GetEnumerator()
        {
/*          elem<T> e = first;
            while (e != null)
            {
                yield return e.value;
                e = e.next;
            }
*/
            return GetEnumerator();
        }

        public IEnumerator<T> GetEnumerator()
        {
            elem<T> e = first;
            while (e != null)
            {
                yield return e.value;
                e = e.next;
            }
        }

        public static Queue<T> operator +(Queue<T> q1, Queue<T> q2)
        {
            Queue<T> res = new Queue<T>();
            foreach (T q in q1)
                res.Enqueue(q);
            foreach (T q in q2)
                res.Enqueue(q);
            return res;
        }

        class elem<V>
        {
            public V value;
            public elem<V> next;
            public elem(V val, elem<V> prev)
            {
                value = val;
                if (prev != null) prev.next = this;
            }
        }
    }

    class t
    {
        void InsertInQueue<T>(Queue<T> q1, T[] tArr)
        {
            foreach (T elem in tArr)
                q1.Enqueue(elem);
        }
    }

}
